// Main shader.

varying vec4 HPosition;
varying vec2 texCoord;
varying vec3 eyePos;
varying vec3 eyeNorm;
varying vec3 lightPos;
varying vec3 Kd;

uniform vec3 Ka;
uniform vec3 Ks;
uniform vec3 lightColour;
uniform vec3 shininess;

void main() 
{
    vec3 N = normalize(eyeNorm);
    vec3 L = normalize(lightPos - eyePos);
    vec3 V = normalize(-eyePos);
    vec3 H = normalize(L+V); //halfangle
    //vec4 lighting = lit(dot(N,L), dot(N,H), shininess.x);
    float difI=dot(N,L);
    float specI=dot(N,H);
    specI=pow(specI,shininess.x);
    
    vec3 C = lightColour * (difI * Kd + specI * Ks + Ka);
    gl_FragColor=vec4(C,1);
}
